#ifndef _RDS_INFO_H
#define _RDS_INFO_H 

#define RDS_INFO_COUNTERS		10000
#define RDS_INFO_CONNECTIONS		10001
#define RDS_INFO_FLOWS			10002
#define RDS_INFO_SEND_MESSAGES		10003
#define RDS_INFO_RETRANS_MESSAGES	10004
#define RDS_INFO_RECV_MESSAGES		10005
#define RDS_INFO_SOCKETS		10006
#define RDS_INFO_TCP_SOCKETS		10007

#define RDS_INFO_FIRST		RDS_INFO_COUNTERS
#define RDS_INFO_LAST		RDS_INFO_TCP_SOCKETS

struct rds_info_lengths {
	unsigned int	nr;
	unsigned int	each;
};

struct rds_info_counter {
	u8		name[32];
	u64		value;
} __attribute__((packed));

#define RDS_INFO_CONNECTION_FLAG_SENDING	0x01
#define RDS_INFO_CONNECTION_FLAG_CONNECTING	0x02
#define RDS_INFO_CONNECTION_FLAG_CONNECTED	0x04

#define RDS_INFO_MESSAGE_FLAG_ACK		0x01
#define RDS_INFO_MESSAGE_FLAG_FAST_ACK		0x02

struct rds_info_connection {
	u64		next_tx_seq;
	u64		next_rx_seq;
	__be32		laddr;
	__be32		faddr;
	u8		transport[15];		/* null term ascii */
	u8		flags;
} __attribute__((packed));

struct rds_info_flow {
	__be32		laddr;
	__be32		faddr;
	u32		bytes;
	__be16		lport;
	__be16		fport;
} __attribute__((packed));

struct rds_info_message {
	u64		seq;
	u32		len;
	__be32		laddr;
	__be32		faddr;
	__be16		lport;
	__be16		fport;
	u8		flags;
} __attribute__((packed));

struct rds_info_socket {
	u32		sndbuf;
	__be32		bound_addr;
	__be32		connected_addr;
	__be16		bound_port;
	__be16		connected_port;
	u32		rcvbuf;
} __attribute__((packed));

struct rds_info_tcp_socket {
	__be32		local_addr;
	__be16		local_port;
	__be32		peer_addr;
	__be16		peer_port;
	u64		hdr_rem;
	u64		data_rem;
	u32		last_sent_nxt;
	u32		last_expected_una;
	u32		last_seen_una;
} __attribute__((packed));

struct rds_info_iterator;

/*
 * These functions must fill in the fields of @lens to reflect the size
 * of the available info source.  If the snapshot fits in @len then it
 * should be copied using @iter.  The caller will deduce if it was copied
 * or not by comparing the lengths.
 */ 
typedef void (*rds_info_func)(struct socket *sock, unsigned int len,
			      struct rds_info_iterator *iter,
			      struct rds_info_lengths *lens);

void rds_info_register_func(int optname, rds_info_func func);
void rds_info_deregister_func(int optname, rds_info_func func);
int rds_info_getsockopt(struct socket *sock, int optname, char __user *optval,
			int __user *optlen);
void rds_info_copy(struct rds_info_iterator *iter, void *data,
		   unsigned long bytes);
void rds_info_iter_unmap(struct rds_info_iterator *iter);


#endif
